﻿/*	AVAILABLE DATA
	thisCommand_obj
		data						This command's data
		run()						This function
		nextEvent()			Function that triggers the next sibling command
		storeTimeout()	Function that stores this command's timeout ID   (used to stop the script)
			var waitId = setTimeout( parentScript.nextEvent, thisCommand_obj.data.value*1000 );
			thisCommand_obj.storeTimeout( waitId );
*/
#include "program/getFullPathFromRelative.as"
//#include "gameProgram/parseVariablePaths.as"
// nestedEval.as
	// evalpath
	// getImpliedValue
	// resolveContainer

// run()
define_teleport = function( thisCommand_obj ){
	
	
	// interrupt all scripts in this level  (doesn't affect common events)
	// this signals to each current rpgSprite's scriptInterruptCheck() that the level is changing and that the current level "doesn't exist"
	ROOT.game_mc.uid = null;
	
	// remove all loops
	LOOP.removeSet( "player" );
	LOOP.removeSet( "scroll" );
	LOOP.removeSet( "sprites" );
	
	
	// wait for fade-out
	thisCommand_obj.fadeOutDone = function()
	{
		var showTrace = Boolean(TRACE_SCRIPT);
		// var showTrace = true;
		
		if(showTrace)
			trace("teleport");
		// figure out the destination path
		if(!thisCommand_obj.data.forceFullPath)
			var relativePath = thisCommand_obj.data.relativeLevel;		// relative path
		var filePath = thisCommand_obj.data.level;								// full path  (old method)
		if(showTrace){
			trace("  fullPath: "+filePath);
			trace("  relativePath: "+relativePath);
		}
		
		// if:  a relative path exists, use it instead of the full path
		if(relativePath != undefined  &&  relativePath != "undefined")
		{
			var currentLevelPath = ROOT.level_xml.filePath;
			filePath = getFullPathFromRelative( relativePath, currentLevelPath );
		}// if:  relative path was specified
		
		// parse variables
		var filePath = nestedEval( filePath, "RAM", "_this" );
		
		// teleport
		if(showTrace)
			trace("  teleporting to: "+filePath);
		// assume strings are variable paths, and add brackets if they're missing
		if(typeof(thisCommand_obj.data.position.x)=="string")
			if(thisCommand_obj.data.position.x.charAt(0)!="[")
				thisCommand_obj.data.position.x = "["+thisCommand_obj.data.position.x+"]";
		if(typeof(thisCommand_obj.data.position.y)=="string")
			if(thisCommand_obj.data.position.y.charAt(0)!="[")
				thisCommand_obj.data.position.y = "["+thisCommand_obj.data.position.y+"]";
		
		var destX = Number( nestedEval( thisCommand_obj.data.position.x, "RAM", "_this" ) );
		var destY = Number( nestedEval( thisCommand_obj.data.position.y, "RAM", "_this" ) );
		if(thisCommand_obj.data.position){
			var newStart = {
				x:destX +8,
				y:destY +8
			}
			var start_point = newStart;
		}else{
			var start_point = {
				x:SPRITES.player._x,
				y:SPRITES.player._y
			}
		}
		// trigger fade-in
		thisCommand_obj.endScript();		// tell the parent script it's being interrupted
		ROOT.loadLevel( filePath, start_point );
//		TRANSITION.fadeIn();					// called automatically by "game_mc" when a map finishes loading
	}// fade-out done()
	
	
	
	if(!LEVEL.alreadyTeleporting)
	{// if:  not already teleporting
		LEVEL.alreadyTeleporting = true;
		// store the player's appearance
		var currentPlayer = SPRITES.player.image.getParams();
		if(currentPlayer)
			RAM.playerSprite = currentPlayer;
		// place transition  &  start everything
		var legacyTransName = thisCommand_obj.data.transition;
		legacyTransName = nestedEval( legacyTransName, "RAM", "_this" );
		
		var transOut = thisCommand_obj.data.transOut;
		transOut.effect = nestedEval( transOut.effect, "RAM", "_this" );
		var transIn = thisCommand_obj.data.transIn;
		transIn.effect = nestedEval( transIn.effect, "RAM", "_this" );
		if(!transOut.effect)		transOut = legacyTransName;		// support legacy teleport data
		
		
		if( TRANSITION ){
			TRANSITION.start( transOut, transIn )
			.then( thisCommand_obj.fadeOutDone );
		}else{
			thisCommand_obj.fadeOutDone();
		}
		
	}// if:  not already teleporting
	
	
	// halt,  do not resume the current script
	// ROOT.loadLevel() will resume the game in its own way
	// ROOT.loadLevel() will fire "onRemoveLevelStart" event
	return VOW.make().doBreak();		// this should halt any scripts and anything else that might wait for this
	
	
}// define_teleport()